/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;

public class PortalUtils {
    @NotNull
    public static Optional<Pair<Portal, Vec3>> raytracePortals(Level world, Vec3 from, Vec3 to, boolean includeGlobalPortal, Predicate<Portal> predicate) {
        return PortalUtils.lenientRayTracePortals(world, from, to, includeGlobalPortal, predicate, 0.001);
    }

    @NotNull
    public static Optional<Pair<Portal, Vec3>> lenientRayTracePortals(Level world, Vec3 from, Vec3 to, boolean includeGlobalPortal, Predicate<Portal> predicate, double leniency) {
        Stream portalStream = McHelper.getEntitiesNearby(world, from, Portal.class, from.m_82554_(to)).stream();
        if (includeGlobalPortal) {
            List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
            portalStream = Streams.concat((Stream[])new Stream[]{portalStream, globalPortals.stream()});
        }
        return portalStream.map(portal -> new Pair(portal, (Object)portal.lenientRayTrace(from, to, leniency))).filter(portalAndHitPos -> portalAndHitPos.getSecond() != null && predicate.test((Portal)portalAndHitPos.getFirst())).min(Comparator.comparingDouble(portalAndHitPos -> ((Vec3)portalAndHitPos.getSecond()).m_82557_(from)));
    }

    public static Optional<Pair<Portal, Vec3>> raytracePortalFromEntityView(Entity player, float tickDelta, double maxDistance, boolean includeGlobalPortal, Predicate<Portal> predicate) {
        Vec3 from = player.m_20299_(tickDelta);
        Vec3 to = from.m_82549_(player.m_20252_(tickDelta).m_82490_(maxDistance));
        Level world = player.m_9236_();
        return PortalUtils.raytracePortals(world, from, to, includeGlobalPortal, predicate);
    }

    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(Entity entity, double maxDistance) {
        return PortalUtils.portalAwareRayTrace(entity.m_9236_(), entity.m_146892_(), entity.m_20252_(1.0f), maxDistance, entity);
    }

    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(Level world, Vec3 startingPoint, Vec3 direction, double maxDistance, Entity entity) {
        return PortalUtils.portalAwareRayTrace(world, startingPoint, direction, maxDistance, entity, List.of());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PortalAwareRaytraceResult portalAwareRayTrace(Level world, Vec3 startingPoint, Vec3 direction, double maxDistance, Entity entity, @NotNull List<Portal> portalsPassingThrough) {
        double portalDistance;
        if (portalsPassingThrough.size() > 5) {
            return null;
        }
        Vec3 endingPoint = startingPoint.m_82549_(direction.m_82490_(maxDistance));
        Optional<Pair<Portal, Vec3>> portalHit = PortalUtils.raytracePortals(world, startingPoint, endingPoint, true, p -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return p.isInteractableBy(player);
            }
            return p.isVisible();
        });
        ClipContext context = new ClipContext(startingPoint, endingPoint, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity);
        BlockHitResult blockHitResult = world.m_45547_(context);
        boolean portalHitFound = portalHit.isPresent();
        boolean blockHitFound = blockHitResult.m_6662_() == HitResult.Type.BLOCK;
        boolean shouldContinueRaytraceInsidePortal = false;
        if (portalHitFound && blockHitFound) {
            double blockDistance;
            portalDistance = ((Vec3)portalHit.get().getSecond()).m_82554_(startingPoint);
            if (!(portalDistance < (blockDistance = blockHitResult.m_82450_().m_82554_(startingPoint)))) return new PortalAwareRaytraceResult(world, blockHitResult, portalsPassingThrough);
            shouldContinueRaytraceInsidePortal = true;
        } else {
            if (!portalHitFound && blockHitFound) {
                return new PortalAwareRaytraceResult(world, blockHitResult, portalsPassingThrough);
            }
            if (portalHitFound && !blockHitFound) {
                shouldContinueRaytraceInsidePortal = true;
            }
        }
        if (!shouldContinueRaytraceInsidePortal) return null;
        portalDistance = ((Vec3)portalHit.get().getSecond()).m_82554_(startingPoint);
        Portal portal = (Portal)portalHit.get().getFirst();
        Vec3 newStartingPoint = portal.transformPoint((Vec3)portalHit.get().getSecond()).m_82549_(portal.getContentDirection().m_82490_(0.001));
        Vec3 newDirection = portal.transformLocalVecNonScale(direction);
        double restDistance = maxDistance - portalDistance;
        if (!(restDistance < 0.0)) return PortalUtils.portalAwareRayTrace(portal.getDestinationWorld(), newStartingPoint, newDirection, restDistance, entity, Stream.concat(portalsPassingThrough.stream(), Stream.of(portal)).collect(Collectors.toList()));
        return null;
    }

    @Deprecated
    public static Optional<Pair<Portal, Vec3>> raytracePortalsFromPlayer(Player player, float tickDelta, double maxDistance, boolean includeGlobalPortal, Predicate<Portal> p) {
        return PortalUtils.raytracePortalFromEntityView((Entity)player, tickDelta, maxDistance, includeGlobalPortal, p);
    }

    public record PortalAwareRaytraceResult(Level world, BlockHitResult hitResult, List<Portal> portalsPassingThrough) {
    }
}

